/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.views;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.google.inject.Inject;
import technology.rocketjump.undermount.rendering.HexColors;
import technology.rocketjump.undermount.rooms.RoomType;
import technology.rocketjump.undermount.rooms.RoomTypeDictionary;
import technology.rocketjump.undermount.ui.GameInteractionMode;
import technology.rocketjump.undermount.ui.i18n.I18nTranslator;
import technology.rocketjump.undermount.ui.skins.GuiSkinRepository;
import technology.rocketjump.undermount.ui.views.GuiView;
import technology.rocketjump.undermount.ui.views.GuiViewName;
import technology.rocketjump.undermount.ui.widgets.ButtonStyle;
import technology.rocketjump.undermount.ui.widgets.IconButton;
import technology.rocketjump.undermount.ui.widgets.IconButtonFactory;

public class RoomSizingGuiView
implements GuiView {
    private final I18nTranslator i18nTranslator;
    private final TextButton backButton;
    private Table viewTable;
    private Table buttonTable;
    private RoomType currentRoomType;

    @Inject
    public RoomSizingGuiView(GuiSkinRepository guiSkinRepository, final MessageDispatcher messageDispatcher, IconButtonFactory iconButtonFactory, RoomTypeDictionary roomTypeDictionary, I18nTranslator i18nTranslator) {
        this.i18nTranslator = i18nTranslator;
        Skin uiSkin = guiSkinRepository.getDefault();
        this.viewTable = new Table(uiSkin);
        this.viewTable.background("default-rect");
        this.buttonTable = new Table(uiSkin);
        IconButton addTilesButton = iconButtonFactory.create("GUI.ADD_TILES", "expand", HexColors.get("#36ba3f"), ButtonStyle.DEFAULT);
        addTilesButton.setAction(() -> messageDispatcher.dispatchMessage(252, (Object)GameInteractionMode.PLACE_ROOM));
        this.buttonTable.add(addTilesButton).pad(20.0f);
        IconButton removeTilesButton = iconButtonFactory.create("GUI.REMOVE_TILES", "contract", HexColors.get("#d42828"), ButtonStyle.DEFAULT);
        removeTilesButton.setAction(() -> messageDispatcher.dispatchMessage(252, (Object)GameInteractionMode.REMOVE_ROOMS));
        this.buttonTable.add(removeTilesButton).pad(20.0f);
        IconButton furnitureButton = iconButtonFactory.create("GUI.BUILD_FURNITURE", "hammer-nails", HexColors.get("#1a7ce1"), ButtonStyle.DEFAULT);
        furnitureButton.setAction(() -> {
            messageDispatcher.dispatchMessage(251, (Object)GuiViewName.ROOM_FURNITURE_SELECTION);
            messageDispatcher.dispatchMessage(252, (Object)GameInteractionMode.DEFAULT);
        });
        this.buttonTable.add(furnitureButton).pad(20.0f);
        this.viewTable.add(this.buttonTable).colspan(2);
        this.viewTable.row();
        this.backButton = new TextButton("Back", uiSkin);
        this.backButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                messageDispatcher.dispatchMessage(251, (Object)GuiViewName.ROOM_SELECTION);
                messageDispatcher.dispatchMessage(252, (Object)GameInteractionMode.DEFAULT);
            }
        });
        this.viewTable.add(this.backButton).pad(10.0f).left().colspan(2);
    }

    @Override
    public GuiViewName getName() {
        return GuiViewName.ROOM_SIZING;
    }

    @Override
    public void populate(Table containerTable) {
        containerTable.clear();
        containerTable.add(this.viewTable);
    }

    @Override
    public void update() {
    }

    public void setCurrentRoomType(RoomType currentRoomType) {
        this.currentRoomType = currentRoomType;
    }

    @Override
    public void onLanguageUpdated() {
        this.backButton.setText(this.i18nTranslator.getTranslatedString("GUI.BACK_LABEL"));
    }
}

